
#define VERSION "Rm16_21"

#define LED 13
#define ON  HIGH
#define OFF LOW
#define WAIT 10000

int LEDstate = OFF;

// Ausgabe:
// Pin an Masse: Delay, dann Bit 0
// Pin offen:         sofort Bit 1
// 11111111 11111111 
// 11111111 11011111 A5
// 11111111 11111111 
// 01111111 11111111 D11

void setup() {
 Serial.begin(38400);
 Serial.println(VERSION);

 pinMode(LED, OUTPUT);
 digitalWrite(LED, ON);

DDRC  = 0xC0;  // 6 Input    A0 - A5
PORTC = 0x3F;

DDRD  = 0x03;  // 6 Input    D2 - D7
PORTD = 0xFC;

DDRB  = 0xF0;  // 4 Input    D8 - D11
PORTB = 0x0F;
}

uint32_t longlong = 0;

#define RMDIM      17         // index 0 nicht verwendet
uint8_t  RMrel[RMDIM]  = {0};
uint16_t Vakanz        = 0;
uint16_t VakanzL       = 0;

byte portCRM = 0;
byte portBRM = 0;
byte portDRM = 0;

unsigned long aktuellZeit = 0;
unsigned long davorZeit   = 0;

uint16_t portsBCD_L = 0;



// BBBBBCCCC CCDDDDDD

void loop() {           // Rueckmeldebits lesen

TrackContacts();

msTimer();

} // loop()



void TrackContacts(void) {
uint16_t change   = 0;
uint16_t bitmask  = 0x0001;
uint16_t output   = 0;

static uint16_t VakanzL  = 0;
uint16_t portsBCD   = 0; // B 4bit, C 6bit, D 6bit
//static uint16_t portsBCD_L = 0;
  
portCRM = PINC & 0x3F;  // A0 - A6
portDRM = PIND & 0xFC;  // D2 - D7
portBRM = PINB & 0x0F;  // D8 - D11

portsBCD = (portBRM << 12) | (portDRM << 4) | (portCRM);


if (portsBCD != portsBCD_L) {           // Veraenderungen ?
   Serial.println(portsBCD);
   davorZeit = aktuellZeit;
   }
portsBCD_L = portsBCD;
 
}  // TrackContacts()


void msTimer(void) {
aktuellZeit = millis();
if (aktuellZeit - davorZeit > WAIT) {
   Serial.println(portsBCD_L);
   davorZeit = aktuellZeit;
   }
} // msTimer()







void PrintBin(uint8_t Value) {

  for(uint8_t m = 0x80; m > 0; m = m>>1) {
    
    if (Value & m) Serial.print('1');
    else Serial.print('0');
  }
  Serial.print(' ');
}


void waitKbd(void) {   
 while (1) {
   if (Serial.available() > 0) {     // Taste gedrückt
     int inByte = Serial.read();     // Taste lesen
     if (inByte == 10) return;       // (LF) Return Taste?       
     }
 }
}
